/*
 * Decompiled with CFR 0.152.
 */
package blueduck.jellyfishing.client.models;

import blueduck.jellyfishing.entity.AbstractJellyfishEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class JellyfishModel<T extends AbstractJellyfishEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("jellyfishing", "jellyfish"), "main");
    private final ModelPart body;
    private final ModelPart tentacle1;
    private final ModelPart tentacle2;
    private final ModelPart tentacle3;
    private final ModelPart tentacle4;

    public JellyfishModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.tentacle1 = this.body.m_171324_("tentacle1");
        this.tentacle2 = this.body.m_171324_("tentacle2");
        this.tentacle3 = this.body.m_171324_("tentacle3");
        this.tentacle4 = this.body.m_171324_("tentacle4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition tentacle1 = body.m_171599_("tentacle1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)3.0f, (float)1.5f));
        PartDefinition tentacle2 = body.m_171599_("tentacle2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)3.0f, (float)1.5f));
        PartDefinition tentacle3 = body.m_171599_("tentacle3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)3.0f, (float)-1.5f));
        PartDefinition tentacle4 = body.m_171599_("tentacle4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)3.0f, (float)-1.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)24, (int)12);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rotateVal = ageInTicks * 0.05f - 20.0f;
        this.tentacle1.f_104203_ = Math.abs(Mth.m_14031_((float)rotateVal)) * 0.5f;
        this.tentacle1.f_104205_ = Math.abs(Mth.m_14031_((float)rotateVal)) * -0.5f;
        this.tentacle2.f_104203_ = Math.abs(Mth.m_14031_((float)rotateVal)) * 0.5f;
        this.tentacle2.f_104205_ = Math.abs(Mth.m_14031_((float)rotateVal)) * 0.5f;
        this.tentacle3.f_104203_ = Math.abs(Mth.m_14031_((float)rotateVal)) * -0.5f;
        this.tentacle3.f_104205_ = Math.abs(Mth.m_14031_((float)rotateVal)) * 0.5f;
        this.tentacle4.f_104203_ = Math.abs(Mth.m_14031_((float)rotateVal)) * -0.5f;
        this.tentacle4.f_104205_ = Math.abs(Mth.m_14031_((float)rotateVal)) * -0.5f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.body).forEach(modelRenderer -> modelRenderer.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
    }

    public void setRotateAngle(ModelPart root, float x, float y, float z) {
        root.f_104203_ = x;
        root.f_104204_ = y;
        root.f_104205_ = z;
    }
}

